#include "ThingSpeak.h"
#include <OneWire.h>
#include <DHT.h>
#include <ESP8266WiFi.h>
   
    char ssid[] = "bera";    //  your network SSID (name) 
    char pass[] = "**********";   // your network password
    int status = WL_IDLE_STATUS;
    WiFiClient  client;

unsigned long myChannelNumber = 279012;
const char * myWriteAPIKey = "BGHYOPLKP41LNHKA";

#define DHTPIN D5   // what pin we're connected to
#define DHTTYPE DHT22   // DHT 22  (AM2302)

DHT dht(DHTPIN, DHTTYPE,11);   //this 11 is for ESP8266

void wifi1() {
  WiFi.begin(ssid, pass);
  WiFi.begin(ssid, pass);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  ThingSpeak.begin(client);
}

void setup() {
  Serial.begin(115200);

  pinMode(DHTPIN,INPUT_PULLUP); 
  dht.begin();
  wifi1();
}

void loop() {
  float h = dht.readHumidity();   
  float t = dht.readTemperature();  // Read temperature as Celsius 
  float f = dht.readTemperature(true);// Read temperature as Fahrenheit
  
  Serial.print(t,2);
  Serial.print(",");
  Serial.println(h,2);

  ThingSpeak.writeField(myChannelNumber, 1, h, myWriteAPIKey);
  WiFi.forceSleepBegin();  //Putting the Modem off
  delay(15000);
  WiFi.forceSleepWake();  //waking up the modem

  ThingSpeak.writeField(myChannelNumber, 2, t, myWriteAPIKey);
  WiFi.forceSleepBegin();
  delay(15000);
  WiFi.forceSleepWake();
}

